/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class BreakOutEffect
extends OneShotEffect {
    BreakOutEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top six cards of your library. You may reveal a creature card from among them. If that card has mana value 2 or less, you may put it onto the battlefield and it gains haste until end of turn. If you didn't put the revealed card onto the battlefield this way, put it into your hand. Put the rest on the bottom of your library in a random order.";
    }

    private BreakOutEffect(BreakOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreakOutEffect copy() {
        return new BreakOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 6));
        controller.lookAtCards(source, null, (Cards)cards, game);
        TargetCard target = new TargetCard(0, 1, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withChooseHint("Reveal a creature card?");
        if (!controller.chooseTarget(this.outcome, (Cards)cards, target, source, game)) {
            return PutCards.BOTTOM_RANDOM.moveCards(controller, (Cards)cards, source, game);
        }
        Card pickedCard = game.getCard(target.getFirstTarget());
        if (pickedCard != null) {
            controller.revealCards(source, (Cards)new CardsImpl(pickedCard), game);
            cards.remove(pickedCard);
            if (pickedCard.getManaValue() <= 2 && controller.chooseUse(Outcome.PutCardInPlay, "Put it onto the battlefield?", source, game) && controller.moveCards(pickedCard, Zone.BATTLEFIELD, source, game)) {
                Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)pickedCard, (Game)game);
                if (permanent != null) {
                    GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            } else {
                controller.moveCards(pickedCard, Zone.HAND, source, game);
            }
        }
        PutCards.BOTTOM_RANDOM.moveCards(controller, (Cards)cards, source, game);
        return true;
    }
}

