/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class BreathstealersCryptEffect
extends ReplacementEffectImpl {
    BreathstealersCryptEffect() {
        super(Duration.WhileOnBattlefield, Outcome.LoseLife);
        this.staticText = "If a player would draw a card, instead they draw a card and reveal it. If it's a creature card, that player discards it unless they pay 3 life";
    }

    private BreathstealersCryptEffect(BreathstealersCryptEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BreathstealersCryptEffect copy() {
        return new BreathstealersCryptEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player == null) {
            return false;
        }
        Card cardDrawn = player.getLibrary().getFromTop(game);
        if (cardDrawn == null || player.drawCards(1, source, game, event) != 1) {
            return true;
        }
        player.revealCards(source, (Cards)new CardsImpl(cardDrawn), game);
        if (!cardDrawn.isCreature(game)) {
            return true;
        }
        game.informPlayers("The card drawn by " + player.getName() + " is a creature card. They discard that card unless they pay 3 life.");
        PayLifeCost cost = new PayLifeCost(3);
        if (!(cost.canPay(source, source, player.getId(), game) && player.chooseUse(this.outcome, "Pay 3 life or discard " + cardDrawn.getIdName() + "?", null, "Pay 3 life", "Discard", source, game) && cost.pay(source, game, source, player.getId(), true, (Cost)cost))) {
            player.discard(cardDrawn, false, source, game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }
}

