/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.token.FoodAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BrenardGingerSculptorEffect
extends OneShotEffect {
    BrenardGingerSculptorEffect() {
        super(Outcome.Copy);
        this.staticText = "you may exile it. If you do, create a token that's a copy of that creature, except it's a 1/1 Food Golem artifact creature in addition to its other types and it has \"{2}, {T}, Sacrifice this artifact: You gain 3 life.\"";
    }

    private BrenardGingerSculptorEffect(BrenardGingerSculptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrenardGingerSculptorEffect copy() {
        return new BrenardGingerSculptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), CardType.CREATURE, false, 1, false, false, null, 1, 1, false);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), card.getZoneChangeCounter(game) + 1));
        effect.setBecomesArtifact(true);
        effect.withAdditionalSubType(SubType.FOOD);
        effect.withAdditionalSubType(SubType.GOLEM);
        effect.addAdditionalAbilities(new Ability[]{new FoodAbility()});
        player.moveCards(card, Zone.EXILED, source, game);
        effect.apply(game, source);
        return true;
    }
}

