/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BreyasApprenticeEffect
extends OneShotEffect {
    BreyasApprenticeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. Until the end of your next turn, you may play that card";
    }

    private BreyasApprenticeEffect(BreyasApprenticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreyasApprenticeEffect copy() {
        return new BreyasApprenticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.moveCardsToExile(card, source, game, true, source.getSourceId(), sourceObject.getIdName());
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.UntilEndOfYourNextTurn).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        return true;
    }
}

