/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class BriberyEffect
extends OneShotEffect {
    BriberyEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search target opponent's library for a creature card and put that card onto the battlefield under your control. Then that player shuffles";
    }

    private BriberyEffect(BriberyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BriberyEffect copy() {
        return new BriberyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && opponent != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)new FilterCreatureCard("creature card"));
            if (controller.searchLibrary(target, source, game, opponent.getId())) {
                Card card = opponent.getLibrary().getCard(target.getFirstTarget(), game);
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            opponent.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

