/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BrightmareEffect
extends OneShotEffect {
    BrightmareEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap up to one target creature. You gain life equal to that creature's power";
    }

    private BrightmareEffect(BrightmareEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrightmareEffect copy() {
        return new BrightmareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.tap(source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(permanent.getPower().getValue(), game, source);
        }
        return true;
    }
}

