/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class BrimazBlightOfOreskosWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    BrimazBlightOfOreskosWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().hasSubtype(SubType.PHYREXIAN, game)) {
            this.players.add(zEvent.getTarget().getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((BrimazBlightOfOreskosWatcher)game.getState().getWatcher(BrimazBlightOfOreskosWatcher.class)).players.contains(source.getControllerId());
    }
}

