/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BringerOfTheLastGiftEffect
extends OneShotEffect {
    BringerOfTheLastGiftEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player sacrifices all other creatures they control. Then each player returns all creature cards from their graveyard that weren't put there this way to the battlefield";
    }

    private BringerOfTheLastGiftEffect(BringerOfTheLastGiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public BringerOfTheLastGiftEffect copy() {
        return new BringerOfTheLastGiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList toSacrifice = new ArrayList();
        for (Object playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            toSacrifice.addAll(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, (UUID)playerId, game));
        }
        HashSet<UUID> notReturned = new HashSet<UUID>();
        for (Permanent p : toSacrifice) {
            if (p.getId().equals(source.getSourceId())) continue;
            p.sacrifice(source, game);
            notReturned.add(p.getMainCard().getId());
        }
        game.processAction();
        HashSet toReturn = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            toReturn.addAll(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        }
        toReturn.removeAll(notReturned.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).collect(Collectors.toSet()));
        controller.moveCards(toReturn, Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

