/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.common.PreventAllDamageToSourceEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;

class BronzeHorsePreventionEffect
extends PreventAllDamageToSourceEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
    private static final Condition condition;

    BronzeHorsePreventionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "as long as you control another creature, prevent all damage that would be dealt to {this} by spells that target it";
    }

    private BronzeHorsePreventionEffect(BronzeHorsePreventionEffect effect) {
        super((PreventAllDamageToSourceEffect)effect);
    }

    public BronzeHorsePreventionEffect copy() {
        return new BronzeHorsePreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game) || !condition.apply(game, source)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getSourceId());
        if (spell == null) {
            return false;
        }
        for (UUID modeId : spell.getStackAbility().getModes().getSelectedModes()) {
            Mode mode = spell.getStackAbility().getModes().get((Object)modeId);
            for (Target target : mode.getTargets()) {
                for (UUID targetId : target.getTargets()) {
                    if (!targetId.equals(source.getSourceId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)filter);
    }
}

