/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.ConditionalMana;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.Condition;
import mage.abilities.keyword.FreerunningAbility;
import mage.abilities.mana.ColorlessManaAbility;
import mage.abilities.mana.ConditionalAnyColorManaAbility;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.Filter;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;

public class BrotherhoodHeadquarters
extends CardImpl {
    private static final Predicate<MageObject> predicate = new AbilityPredicate(FreerunningAbility.class);

    public BrotherhoodHeadquarters(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new ColorlessManaAbility());
        this.addAbility((Ability)new ConditionalAnyColorManaAbility(1, (ConditionalManaBuilder)new BrotherhoodHeadquartersManaBuilder()));
    }

    public BrotherhoodHeadquarters(BrotherhoodHeadquarters card) {
        super((CardImpl)card);
    }

    public BrotherhoodHeadquarters copy() {
        return new BrotherhoodHeadquarters(this);
    }

    class BrotherhoodHeadquartersAssassinSourceManaCondition
    implements Condition {
        BrotherhoodHeadquartersAssassinSourceManaCondition() {
        }

        public boolean apply(Game game, Ability source) {
            if (source.isActivatedAbility()) {
                MageObject object = game.getObject(source.getSourceId());
                return object != null && object.hasSubtype(SubType.ASSASSIN, game);
            }
            return false;
        }
    }

    class BrotherhoodHeadquartersFreerunningManaCondition
    implements Condition {
        BrotherhoodHeadquartersFreerunningManaCondition() {
        }

        public boolean apply(Game game, Ability source) {
            MageObject sourceObject = game.getObject(source);
            return sourceObject != null && predicate.apply((Object)sourceObject, game);
        }
    }

    class BrotherhoodHeadquartersAssassinSpellManaCondition
    implements Condition {
        BrotherhoodHeadquartersAssassinSpellManaCondition() {
        }

        public boolean apply(Game game, Ability source) {
            if (source instanceof SpellAbility) {
                Card card = game.getCard(source.getSourceId());
                return card != null && card.hasSubtype(SubType.ASSASSIN, game);
            }
            return false;
        }
    }

    class BrotherhoodHeadquartersConditionalMana
    extends ConditionalMana {
        public BrotherhoodHeadquartersConditionalMana(Mana mana) {
            super(mana);
            this.addCondition(new BrotherhoodHeadquartersAssassinSpellManaCondition());
            this.addCondition(new BrotherhoodHeadquartersFreerunningManaCondition());
            this.addCondition(new BrotherhoodHeadquartersAssassinSourceManaCondition());
            this.setComparisonScope(Filter.ComparisonScope.Any);
        }
    }

    class BrotherhoodHeadquartersManaBuilder
    extends ConditionalManaBuilder {
        BrotherhoodHeadquartersManaBuilder() {
        }

        public String getRule() {
            return "Spend this mana only to cast an Assassin spell or a spell that has freerunning, or to activate an ability of an Assassin source.";
        }

        public ConditionalMana build(Object ... options) {
            return new BrotherhoodHeadquartersConditionalMana((Mana)this.mana);
        }
    }
}

