/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.keyword.EquipAbility;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class BruenorBattlehammerWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    BruenorBattlehammerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject object = game.getStack().getStackObject(event.getSourceId());
        if (object != null && object.getStackAbility() instanceof EquipAbility) {
            this.playerSet.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        BruenorBattlehammerWatcher watcher = (BruenorBattlehammerWatcher)game.getState().getWatcher(BruenorBattlehammerWatcher.class);
        return watcher != null && watcher.playerSet.contains(playerId);
    }
}

