/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.filter.predicate.permanent.AuraPermanentCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPermanent;

class BrunaLightOfAlabasterEffect
extends OneShotEffect {
    BrunaLightOfAlabasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "attach to it any number of Auras on the battlefield and you may put onto the battlefield attached to it any number of Aura cards that could enchant it from your graveyard and/or hand";
    }

    private BrunaLightOfAlabasterEffect(BrunaLightOfAlabasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrunaLightOfAlabasterEffect copy() {
        return new BrunaLightOfAlabasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID bruna = source.getSourceId();
        FilterPermanent filterAura = new FilterPermanent("Aura");
        FilterCard filterAuraCard = new FilterCard("Aura card");
        filterAura.add((Predicate)CardType.ENCHANTMENT.getPredicate());
        filterAura.add((Predicate)SubType.AURA.getPredicate());
        filterAura.add((Predicate)new AuraPermanentCanAttachToPermanentId(bruna));
        filterAuraCard.add((Predicate)CardType.ENCHANTMENT.getPredicate());
        filterAuraCard.add((Predicate)SubType.AURA.getPredicate());
        filterAuraCard.add((Predicate)new AuraCardCanAttachToPermanentId(bruna));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        ArrayList<Permanent> fromBattlefield = new ArrayList<Permanent>();
        ArrayList<Card> fromHandGraveyard = new ArrayList<Card>();
        int countBattlefield = (int)((long)game.getBattlefield().getActivePermanents(filterAura, source.getControllerId(), source, game).size() - sourcePermanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> permanent != null && permanent.hasSubtype(SubType.AURA, game)).count());
        while (controller.canRespond() && countBattlefield > 0 && controller.chooseUse(Outcome.Benefit, "Attach an Aura from the battlefield?", source, game)) {
            Target target;
            Permanent aura;
            TargetPermanent targetAura = new TargetPermanent(filterAura);
            targetAura.withNotTarget(true);
            if (!controller.choose(Outcome.Benefit, (Target)targetAura, source, game) || (aura = game.getPermanent(targetAura.getFirstTarget())) == null || (target = (Target)aura.getSpellAbility().getTargets().get(0)) == null) continue;
            fromBattlefield.add(aura);
            filterAura.add(Predicates.not((Predicate)new CardIdPredicate(aura.getId())));
            countBattlefield = (int)((long)game.getBattlefield().getActivePermanents(filterAura, source.getControllerId(), source, game).size() - sourcePermanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> permanent != null && permanent.hasSubtype(SubType.AURA, game)).count());
        }
        int countHand = controller.getHand().count(filterAuraCard, game);
        while (controller.canRespond() && countHand > 0 && controller.chooseUse(Outcome.Benefit, "Attach an Aura from your hand?", source, game)) {
            Target target;
            Card aura;
            TargetCard targetAura = new TargetCard(Zone.HAND, filterAuraCard);
            if (!controller.choose(Outcome.Benefit, controller.getHand(), targetAura, source, game) || (aura = game.getCard(targetAura.getFirstTarget())) == null || (target = (Target)aura.getSpellAbility().getTargets().get(0)) == null) break;
            fromHandGraveyard.add(aura);
            filterAuraCard.add(Predicates.not((Predicate)new CardIdPredicate(aura.getId())));
            countHand = controller.getHand().count(filterAuraCard, game);
        }
        int countGraveyard = controller.getGraveyard().count(filterAuraCard, game);
        while (controller.canRespond() && countGraveyard > 0 && controller.chooseUse(Outcome.Benefit, "Attach an Aura from your graveyard?", source, game)) {
            Target target;
            Card card;
            TargetCard targetAura = new TargetCard(Zone.GRAVEYARD, filterAuraCard);
            if (!controller.choose(Outcome.Benefit, (Cards)controller.getGraveyard(), targetAura, source, game) || (card = game.getCard(targetAura.getFirstTarget())) == null || (target = (Target)card.getSpellAbility().getTargets().get(0)) == null) break;
            fromHandGraveyard.add(card);
            filterAuraCard.add(Predicates.not((Predicate)new CardIdPredicate(card.getId())));
            countGraveyard = controller.getGraveyard().count(filterAuraCard, game);
        }
        for (Permanent permanent2 : fromBattlefield) {
            Permanent attachedTo = game.getPermanent(permanent2.getAttachedTo());
            if (attachedTo != null) {
                attachedTo.removeAttachment(permanent2.getId(), source, game);
            }
            sourcePermanent.addAttachment(permanent2.getId(), source, game);
        }
        for (Card card : fromHandGraveyard) {
            if (card == null) continue;
            game.getState().setValue("attachTo:" + card.getId(), (Object)sourcePermanent);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            sourcePermanent.addAttachment(card.getId(), source, game);
        }
        return true;
    }
}

