/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.replacement.DealtDamageToCreatureBySourceDies;
import mage.abilities.keyword.DevoidAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterSpellOrPermanent;
import mage.target.common.TargetCreatureOrPlaneswalker;
import mage.target.common.TargetSpellOrPermanent;
import mage.watchers.Watcher;
import mage.watchers.common.DamagedByWatcher;

public final class BrutalExpulsion
extends CardImpl {
    private static final FilterSpellOrPermanent filter = new FilterSpellOrPermanent("spell or creature");

    public BrutalExpulsion(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{U}{R}");
        this.addAbility((Ability)new DevoidAbility(this.color));
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget(new TargetSpellOrPermanent(1, 1, filter, false).withChooseHint("return to its owner's hand"));
        Mode mode = new Mode((Effect)new DamageTargetEffect(2));
        DealtDamageToCreatureBySourceDies effect = new DealtDamageToCreatureBySourceDies((Card)this, Duration.EndOfTurn);
        effect.setText("If that creature or planeswalker would die this turn, exile it instead");
        mode.addEffect((Effect)effect);
        mode.addTarget(new TargetCreatureOrPlaneswalker().withChooseHint("deals 2 damage and exile instead"));
        this.getSpellAbility().addMode(mode);
        this.getSpellAbility().addWatcher((Watcher)new DamagedByWatcher(true));
    }

    private BrutalExpulsion(BrutalExpulsion card) {
        super((CardImpl)card);
    }

    public BrutalExpulsion copy() {
        return new BrutalExpulsion(this);
    }

    static {
        filter.setPermanentFilter((FilterPermanent)new FilterCreaturePermanent());
    }
}

