/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CardType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BrutalSuppressionAdditionalCostEffect
extends CostModificationEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a land");
    private static final FilterPermanent filter2;

    BrutalSuppressionAdditionalCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Activated abilities of nontoken Rebels cost an additional \"Sacrifice a land\" to activate";
    }

    private BrutalSuppressionAdditionalCostEffect(BrutalSuppressionAdditionalCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        abilityToModify.addCost((Cost)new SacrificeTargetCost((FilterPermanent)filter));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Permanent rebelPermanent;
        if (abilityToModify.isActivatedAbility() && (rebelPermanent = game.getPermanent(abilityToModify.getSourceId())) != null) {
            return filter2.match((Object)rebelPermanent, game);
        }
        return false;
    }

    public BrutalSuppressionAdditionalCostEffect copy() {
        return new BrutalSuppressionAdditionalCostEffect(this);
    }

    static {
        filter.add((Predicate)CardType.LAND.getPredicate());
        filter2 = new FilterPermanent("nontoken Rebels");
        filter2.add((Predicate)SubType.REBEL.getPredicate());
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

