/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BuildersBaneEffect
extends OneShotEffect {
    BuildersBaneEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy X target artifacts. {this} deals damage to each player equal to the number of artifacts they controlled that were put into a graveyard this way";
    }

    private BuildersBaneEffect(BuildersBaneEffect effect) {
        super((OneShotEffect)effect);
    }

    public BuildersBaneEffect copy() {
        return new BuildersBaneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> destroyedArtifactPerPlayer = new HashMap<UUID, Integer>();
        for (UUID uUID : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(uUID);
            if (permanent == null || !permanent.destroy(source, game, false)) continue;
            game.processAction();
            if (permanent.getZoneChangeCounter(game) + 1 == game.getState().getZoneChangeCounter(permanent.getId()) && game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) continue;
            destroyedArtifactPerPlayer.merge(permanent.getControllerId(), 1, Integer::sum);
        }
        for (Map.Entry entry : destroyedArtifactPerPlayer.entrySet()) {
            Player player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            player.damage(((Integer)entry.getValue()).intValue(), source.getSourceId(), source, game);
        }
        return true;
    }
}

