/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BurdenOfProofEffect
extends ContinuousEffectImpl {
    BurdenOfProofEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "enchanted creature gets +2/+2 as long as it's a Detective you control. Otherwise, it has base power and toughness 1/1";
    }

    private BurdenOfProofEffect(BurdenOfProofEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BurdenOfProofEffect copy() {
        return new BurdenOfProofEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (layer != Layer.PTChangingEffects_7) {
            return false;
        }
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).filter(Objects::nonNull).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        if (permanent.isControlledBy(source.getControllerId()) && permanent.hasSubtype(SubType.DETECTIVE, game)) {
            if (sublayer == SubLayer.ModifyPT_7c) {
                permanent.getPower().increaseBoostedValue(2);
                permanent.getToughness().increaseBoostedValue(2);
                return true;
            }
        } else if (sublayer == SubLayer.SetPT_7b) {
            permanent.getPower().setModifiedBaseValue(1);
            permanent.getToughness().setModifiedBaseValue(1);
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7;
    }
}

