/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.InfectAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BurnTheImpureEffect
extends OneShotEffect {
    BurnTheImpureEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to target creature. If that creature has infect, {this} deals 3 damage to that creature's controller.";
    }

    private BurnTheImpureEffect(BurnTheImpureEffect effect) {
        super((OneShotEffect)effect);
    }

    public BurnTheImpureEffect copy() {
        return new BurnTheImpureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            Player controller;
            permanent.damage(3, source.getSourceId(), source, game, false, true);
            if (permanent.getAbilities().contains((Ability)InfectAbility.getInstance()) && (controller = game.getPlayer(permanent.getControllerId())) != null) {
                controller.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

