/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BuzzardWaspColonyEffect
extends OneShotEffect {
    BuzzardWaspColonyEffect() {
        super(Outcome.Benefit);
        this.staticText = "if it had counters on it, put its counters on {this}";
    }

    private BuzzardWaspColonyEffect(BuzzardWaspColonyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BuzzardWaspColonyEffect copy() {
        return new BuzzardWaspColonyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = (Permanent)this.getValue("creatureDied");
        if (permanent == null || creature == null) {
            return false;
        }
        for (Counter counter : creature.getCounters(game).values()) {
            permanent.addCounters(counter.copy(), source, game);
        }
        return true;
    }
}

