/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class DiesWhileInGraveyardTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterCreaturePermanent filter;

    public DiesWhileInGraveyardTriggeredAbility(Effect effect, FilterCreaturePermanent filter) {
        super(Zone.GRAVEYARD, effect, false);
        this.filter = filter;
        this.setTriggerPhrase("Whenever " + filter.getMessage() + " dies while {this} is in your graveyard, ");
    }

    private DiesWhileInGraveyardTriggeredAbility(DiesWhileInGraveyardTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.filter = ability.filter;
    }

    public DiesWhileInGraveyardTriggeredAbility copy() {
        return new DiesWhileInGraveyardTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        for (Zone z : Zone.values()) {
            if (!game.checkShortLivingLKI(this.sourceId, z) || z == Zone.GRAVEYARD) continue;
            return false;
        }
        return this.filter.match(zEvent.getTarget(), this.controllerId, (Ability)this, game);
    }
}

