/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class FurnaceOfRathEffect
extends ReplacementEffectImpl {
    FurnaceOfRathEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "If a creature would deal combat damage to a creature this turn, it deals double that damage to that creature instead";
    }

    private FurnaceOfRathEffect(FurnaceOfRathEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FurnaceOfRathEffect copy() {
        return new FurnaceOfRathEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && ((DamageEvent)event).isCombatDamage();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

