/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LoseControlTriggeredAbility
extends TriggeredAbilityImpl {
    public LoseControlTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("When a player other than {this}'s owner controls it, ");
    }

    private LoseControlTriggeredAbility(LoseControlTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LoseControlTriggeredAbility copy() {
        return new LoseControlTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_CONTROL || event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent;
        if (event.getTargetId().equals(this.getSourceId()) && (sourcePermanent = game.getPermanent(event.getTargetId())) != null) {
            return !sourcePermanent.getControllerId().equals(sourcePermanent.getOwnerId());
        }
        return false;
    }
}

