/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.BecomesBasicLandTargetEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BecomeSwampEffect
extends BecomesBasicLandTargetEffect {
    BecomeSwampEffect() {
        super(Duration.Custom, false, true, new SubType[]{SubType.SWAMP});
        this.staticText = "That land is a Swamp for as long as it has a mire counter on it";
    }

    private BecomeSwampEffect(BecomeSwampEffect effect) {
        super((BecomesBasicLandTargetEffect)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent land = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (land == null || land.getCounters(game).getCount(CounterType.MIRE) < 1) {
            this.discard();
            return false;
        }
        return super.apply(layer, sublayer, source, game);
    }

    public BecomeSwampEffect copy() {
        return new BecomeSwampEffect(this);
    }
}

