/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CabalTherapistDiscardEffect
extends OneShotEffect {
    CabalTherapistDiscardEffect() {
        super(Outcome.Discard);
    }

    private CabalTherapistDiscardEffect(CabalTherapistDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (targetPlayer == null || controller == null || sourceObject == null || cardName == null) {
            return false;
        }
        Cards hand = targetPlayer.getHand().copy();
        targetPlayer.revealCards(source, hand, game);
        hand.removeIf(uuid -> {
            Card card = hand.get(uuid, game);
            if (card == null) {
                return true;
            }
            return !CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game);
        });
        targetPlayer.discard(hand, false, source, game);
        return true;
    }

    public CabalTherapistDiscardEffect copy() {
        return new CabalTherapistDiscardEffect(this);
    }
}

