/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CalculatingLichTriggeredAbility
extends TriggeredAbilityImpl {
    CalculatingLichTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private CalculatingLichTriggeredAbility(CalculatingLichTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(this.getControllerId());
        UUID defenderId = game.getCombat().getDefenderId(event.getSourceId());
        if (player == null || !player.hasOpponent(defenderId, game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new LoseLifeTargetEffect(1).setTargetPointer((TargetPointer)new FixedTarget(defenderId, game)));
        return true;
    }

    public String getRule() {
        return "Whenever a creature attacks one of your opponents, that player loses 1 life.";
    }

    public CalculatingLichTriggeredAbility copy() {
        return new CalculatingLichTriggeredAbility(this);
    }
}

