/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CalixDestinysHandDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference theirMor;
    private final MageObjectReference myMor;

    CalixDestinysHandDelayedTriggeredAbility(MageObjectReference theirMor, MageObjectReference myMor) {
        super(null, Duration.Custom, true, false);
        this.theirMor = theirMor;
        this.myMor = myMor;
        this.usesStack = false;
    }

    private CalixDestinysHandDelayedTriggeredAbility(CalixDestinysHandDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.theirMor = ability.theirMor;
        this.myMor = ability.myMor;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD || !this.myMor.refersTo((MageObject)zEvent.getTarget(), game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false).setTargetPointer((TargetPointer)new FixedTarget(this.theirMor)));
        return true;
    }

    public CalixDestinysHandDelayedTriggeredAbility copy() {
        return new CalixDestinysHandDelayedTriggeredAbility(this);
    }
}

