/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class CallousGiantEffect
extends PreventionEffectImpl {
    CallousGiantEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If a source would deal 3 or less damage to {this}, prevent that damage.";
    }

    private CallousGiantEffect(CallousGiantEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public CallousGiantEffect copy() {
        return new CallousGiantEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event.getAmount() <= 3) {
            this.preventDamageAction(event, source, game);
            return true;
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId());
    }
}

