/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class CallousOppressorChooseCreatureTypeEffect
extends OneShotEffect {
    CallousOppressorChooseCreatureTypeEffect() {
        super(Outcome.Benefit);
        this.staticText = "an opponent chooses a creature type";
    }

    private CallousOppressorChooseCreatureTypeEffect(CallousOppressorChooseCreatureTypeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller != null) {
            TargetOpponent target = new TargetOpponent(true);
            if (target.canChoose(controller.getId(), source, game)) {
                while (!target.isChosen(game) && target.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                    controller.chooseTarget(this.outcome, (Target)target, source, game);
                }
            } else {
                return false;
            }
            Player opponent = game.getPlayer(target.getFirstTarget());
            if (opponent != null && mageObject != null) {
                ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
                if (!opponent.choose(this.outcome, (Choice)typeChoice, game)) {
                    return false;
                }
                if (typeChoice.getChoiceKey() == null) {
                    return false;
                }
                if (!game.isSimulation()) {
                    game.informPlayers(mageObject.getName() + ": " + opponent.getLogName() + " has chosen " + typeChoice.getChoiceKey());
                }
                game.getState().setValue(mageObject.getId() + "_type", (Object)SubType.byDescription((String)typeChoice.getChoiceKey()));
                if (mageObject instanceof Permanent) {
                    mageObject.addInfo("chosen type", CardUtil.addToolTipMarkTags((String)("Chosen type: " + typeChoice.getChoiceKey())), game);
                }
                return true;
            }
        }
        return false;
    }

    public CallousOppressorChooseCreatureTypeEffect copy() {
        return new CallousOppressorChooseCreatureTypeEffect(this);
    }
}

