/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CalmingVerseEffect
extends OneShotEffect {
    private static final FilterPermanent untappedLandFilter = new FilterPermanent("If you control an untapped land");
    private static final FilterEnchantmentPermanent opponentEnchantmentsFilter;
    private static final FilterControlledEnchantmentPermanent controlledEnchantmentsFilter;

    public CalmingVerseEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy all enchantments you don't control. Then if you control an untapped land, destroy all enchantments you control";
    }

    private CalmingVerseEffect(CalmingVerseEffect effect) {
        super((OneShotEffect)effect);
    }

    public CalmingVerseEffect copy() {
        return new CalmingVerseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)opponentEnchantmentsFilter, source.getControllerId(), source, game)) {
            permanent.destroy(source, game, false);
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && game.getBattlefield().countAll(untappedLandFilter, controller.getId(), game) > 0) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)controlledEnchantmentsFilter, source.getControllerId(), source, game)) {
                permanent.destroy(source, game, false);
            }
        }
        return true;
    }

    static {
        untappedLandFilter.add((Predicate)CardType.LAND.getPredicate());
        untappedLandFilter.add((Predicate)TappedPredicate.UNTAPPED);
        opponentEnchantmentsFilter = new FilterEnchantmentPermanent("enchantments you don't control");
        opponentEnchantmentsFilter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        controlledEnchantmentsFilter = new FilterControlledEnchantmentPermanent("enchantments you control");
    }
}

