/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CamelEffect
extends PreventionEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent("Deserts");

    CamelEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false);
        this.staticText = "As long as {this} is attacking, prevent all damage Deserts would deal to {this} and to creatures banded with {this}";
    }

    private CamelEffect(CamelEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public CamelEffect copy() {
        return new CamelEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0) {
            Permanent permanent;
            DamageEvent damageEvent = (DamageEvent)event;
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
            if (sourcePermanent != null && sourcePermanent.isAttacking() && (event.getTargetId().equals(source.getSourceId()) || sourcePermanent.getBandedCards().contains(event.getTargetId())) && filter.match((Object)(permanent = game.getPermanentOrLKIBattlefield(damageEvent.getSourceId())), game)) {
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.DESERT.getPredicate());
    }
}

