/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAttackingCreature;
import mage.target.common.TargetSacrifice;

class CampsiteCuisineEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.FOOD, "Foods");

    CampsiteCuisineEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice X Foods. When you do, up to X target attacking creatures each get +3/+3 and gain trample and indestructible until end of turn";
    }

    private CampsiteCuisineEffect(CampsiteCuisineEffect effect) {
        super((OneShotEffect)effect);
    }

    public CampsiteCuisineEffect copy() {
        return new CampsiteCuisineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, filter);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++count;
        }
        if (count < 1) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new BoostTargetEffect(3, 3).setText("up to X target attacking creatures each get +3/+3"), false);
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance()).setText("and gain trample"));
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance()).setText("and indestructible until end of turn"));
        ability.addTarget((Target)new TargetAttackingCreature(0, count));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

