/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CanalCourierTriggeredAbility
extends TriggeredAbilityImpl {
    public CanalCourierTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever {this} and another creature attack different players, ");
    }

    private CanalCourierTriggeredAbility(CanalCourierTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CanalCourierTriggeredAbility copy() {
        return new CanalCourierTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID sourceDefenderId;
        Player attackedPlayer;
        Permanent permanent = game.getPermanent(this.getSourceId());
        if (permanent != null && permanent.isAttacking() && (attackedPlayer = game.getPlayer(sourceDefenderId = game.getCombat().getDefenderId(permanent.getId()))) != null) {
            for (UUID attacker : game.getCombat().getAttackers()) {
                UUID defenderId;
                Player attackedPlayer2;
                if (Objects.equals(attacker, permanent.getId()) || (attackedPlayer2 = game.getPlayer(defenderId = game.getCombat().getDefenderId(attacker))) == null || !attackedPlayer.getId().equals(attackedPlayer2.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

