/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.Card;
import mage.cards.c.CantStayAwayReplacementEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CantStayAwayEffect
extends OneShotEffect {
    CantStayAwayEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target creature card with mana value 3 or less from your graveyard to the battlefield. It gains \"If this creature would die, exile it instead.\"";
    }

    private CantStayAwayEffect(CantStayAwayEffect effect) {
        super((OneShotEffect)effect);
    }

    public CantStayAwayEffect copy() {
        return new CantStayAwayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(source.getFirstTarget());
        if (controller == null || targetCard == null || game.getState().getZone(targetCard.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        controller.moveCards(targetCard, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)targetCard, (Game)game);
        if (permanent != null) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)new SimpleStaticAbility((Effect)new CantStayAwayReplacementEffect()), Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

