/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.util.RandomUtil;

class CapriciousEfreetEffect
extends OneShotEffect {
    CapriciousEfreetEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "choose target nonland permanent you control and up to two target nonland permanents you don't control. Destroy one of them at random";
    }

    private CapriciousEfreetEffect(CapriciousEfreetEffect effect) {
        super((OneShotEffect)effect);
    }

    public CapriciousEfreetEffect copy() {
        return new CapriciousEfreetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> targetPermanents = new ArrayList<Permanent>();
        Permanent permanent = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        if (permanent != null) {
            targetPermanents.add(permanent);
        }
        for (UUID targetID : ((Target)source.getTargets().get(1)).getTargets()) {
            permanent = game.getPermanent(targetID);
            if (permanent == null) continue;
            targetPermanents.add(permanent);
        }
        if (!targetPermanents.isEmpty()) {
            permanent = (Permanent)targetPermanents.get(RandomUtil.nextInt((int)targetPermanents.size()));
            permanent.destroy(source, game, false);
            return true;
        }
        return false;
    }
}

