/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CaptivatingVampireEffect
extends ContinuousEffectImpl {
    CaptivatingVampireEffect() {
        super(Duration.Custom, Outcome.Detriment);
        this.staticText = "Gain control of target creature. It becomes a Vampire in addition to its other types";
    }

    private CaptivatingVampireEffect(CaptivatingVampireEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CaptivatingVampireEffect copy() {
        return new CaptivatingVampireEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            switch (layer) {
                case ControlChangingEffects_2: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.changeControllerId(source.getControllerId(), game, source);
                    break;
                }
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.VAMPIRE});
                }
            }
            return true;
        }
        this.discard();
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.ControlChangingEffects_2 || layer == Layer.TypeChangingEffects_4;
    }
}

