/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.replacement.DiesReplacementEffect;
import mage.abilities.effects.common.ruleModifying.CantRegenerateTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CarbonizeEffect
extends OneShotEffect {
    CarbonizeEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a creature, it can't be regenerated this turn, and if it would die this turn, exile it instead";
    }

    private CarbonizeEffect(CarbonizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CarbonizeEffect copy() {
        return new CarbonizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        game.addEffect(new CantRegenerateTargetEffect(Duration.EndOfTurn, "").setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect((ContinuousEffect)new DiesReplacementEffect(new MageObjectReference((MageObject)permanent, game), Duration.EndOfTurn), source);
        return true;
    }
}

