/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTargetsPermanentCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class CarnivorousCanopy
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("artifact, enchantment, or creature with flying");
    private static final FilterPermanent filter2 = new FilterPermanent();
    private static final Condition condition;

    public CarnivorousCanopy(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{G}");
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
        this.getSpellAbility().addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new ProliferateEffect(), condition, "If that permanent's mana value was 3 or less, proliferate. <i>(Choose any number of permanents and/or players, then give each another counter of each kind already there.)</i>"));
    }

    private CarnivorousCanopy(CarnivorousCanopy card) {
        super((CardImpl)card);
    }

    public CarnivorousCanopy copy() {
        return new CarnivorousCanopy(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.ENCHANTMENT.getPredicate(), Predicates.and((Predicate)CardType.CREATURE.getPredicate(), (Predicate)new AbilityPredicate(FlyingAbility.class))}));
        filter2.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
        condition = new SourceTargetsPermanentCondition(filter2);
    }
}

