/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;

enum CarrionGrubValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player = game.getPlayer(sourceAbility.getControllerId());
        if (player == null) {
            return 0;
        }
        return player.getGraveyard().getCards(game).stream().filter(Objects::nonNull).filter(card -> card.isCreature(game)).map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0);
    }

    public CarrionGrubValue copy() {
        return instance;
    }

    public String getMessage() {
        return "the greatest power among creature cards in your graveyard";
    }

    public String toString() {
        return "X";
    }
}

