/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CarrionLocustEffect
extends OneShotEffect {
    CarrionLocustEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target card from an opponent's graveyard. If it was a creature card, that player loses 1 life";
    }

    private CarrionLocustEffect(CarrionLocustEffect effect) {
        super((OneShotEffect)effect);
    }

    public CarrionLocustEffect copy() {
        return new CarrionLocustEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card targetCard = game.getCard(source.getFirstTarget());
        if (targetCard == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean creature = targetCard.isCreature(game);
        Player owner = game.getPlayer(targetCard.getOwnerId());
        controller.moveCards(targetCard, Zone.EXILED, source, game);
        if (creature && owner != null) {
            owner.loseLife(1, game, source, false);
        }
        return true;
    }
}

