/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.ClueArtifactToken;

class CaseOfThePilferedProofReplacementEffect
extends ReplacementEffectImpl {
    CaseOfThePilferedProofReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If one or more tokens would be created under your control, those tokens plus a Clue token are created instead";
    }

    private CaseOfThePilferedProofReplacementEffect(CaseOfThePilferedProofReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CaseOfThePilferedProofReplacementEffect copy() {
        return new CaseOfThePilferedProofReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent) {
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            ClueArtifactToken clueToken = null;
            Map tokens = tokenEvent.getTokens();
            for (Map.Entry entry : tokens.entrySet()) {
                if (!(entry.getKey() instanceof ClueArtifactToken)) continue;
                clueToken = (ClueArtifactToken)entry.getKey();
            }
            if (clueToken == null) {
                clueToken = new ClueArtifactToken();
            }
            tokens.put(clueToken, tokens.getOrDefault(clueToken, 0) + 1);
        }
        return false;
    }
}

