/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CauldronDanceReturnFromGraveyardToBattlefieldTargetEffect
extends OneShotEffect {
    CauldronDanceReturnFromGraveyardToBattlefieldTargetEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target creature card from your graveyard to the battlefield. That creature gains haste. Return it to your hand at the beginning of the next end step";
    }

    private CauldronDanceReturnFromGraveyardToBattlefieldTargetEffect(CauldronDanceReturnFromGraveyardToBattlefieldTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public CauldronDanceReturnFromGraveyardToBattlefieldTargetEffect copy() {
        return new CauldronDanceReturnFromGraveyardToBattlefieldTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID targetId = this.getTargetPointer().getFirst(game, source);
            Card card = game.getCard(targetId);
            if (card != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                if (creature != null) {
                    GainAbilityTargetEffect hasteEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
                    hasteEffect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                    game.addEffect((ContinuousEffect)hasteEffect, source);
                    ReturnToHandTargetEffect returnToHandEffect = new ReturnToHandTargetEffect();
                    returnToHandEffect.setText("return that creature to your hand");
                    returnToHandEffect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                    AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)returnToHandEffect);
                    game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                }
            }
            return true;
        }
        return false;
    }
}

