/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.SaddledCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CausticBroncoEffect
extends OneShotEffect {
    CausticBroncoEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library and put it into your hand. You lose life equal to that card's mana value if {this} isn't saddled. Otherwise, each opponent loses that much life";
    }

    private CausticBroncoEffect(CausticBroncoEffect effect) {
        super((OneShotEffect)effect);
    }

    public CausticBroncoEffect copy() {
        return new CausticBroncoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        player.moveCards(card, Zone.HAND, source, game);
        if (!SaddledCondition.instance.apply(game, source)) {
            player.loseLife(card.getManaValue(), game, source, false);
            return true;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            opponent.loseLife(card.getManaValue(), game, source, false);
        }
        return true;
    }
}

