/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CeaselessSearbladesTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCard filter = new FilterCard("an Elemental");

    CeaselessSearbladesTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 0, Duration.EndOfTurn), false);
        this.setTriggerPhrase("Whenever you activate an ability of an Elemental, ");
    }

    private CeaselessSearbladesTriggeredAbility(CeaselessSearbladesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CeaselessSearbladesTriggeredAbility copy() {
        return new CeaselessSearbladesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.TAPPED_FOR_MANA && game.inCheckPlayableState()) {
            return false;
        }
        Permanent source = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return event.getPlayerId().equals(this.getControllerId()) && source != null && filter.match((Card)source, game);
    }

    static {
        filter.add((Predicate)SubType.ELEMENTAL.getPredicate());
    }
}

