/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CelesRuneKnightEffect
extends OneShotEffect {
    CelesRuneKnightEffect() {
        super(Outcome.DrawCard);
        this.staticText = "discard any number of cards, then draw that many cards plus one";
    }

    private CelesRuneKnightEffect(CelesRuneKnightEffect effect) {
        super((OneShotEffect)effect);
    }

    public CelesRuneKnightEffect copy() {
        return new CelesRuneKnightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int discarded = player.discard(0, Integer.MAX_VALUE, false, source, game).size();
        game.processAction();
        player.drawCards(discarded + 1, source, game);
        return true;
    }
}

