/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CelestialDawnToPlainsEffect
extends ContinuousEffectImpl {
    private static final FilterLandPermanent filter = new FilterLandPermanent();

    CelestialDawnToPlainsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Lands you control are Plains";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        this.dependencyTypes.add(DependencyType.BecomePlains);
    }

    private CelestialDawnToPlainsEffect(CelestialDawnToPlainsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public CelestialDawnToPlainsEffect copy() {
        return new CelestialDawnToPlainsEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent land : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    land.removeAllAbilities(source.getSourceId(), game);
                    land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                    break;
                }
                case TypeChangingEffects_4: {
                    land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                    land.addSubType(game, new SubType[]{SubType.PLAINS});
                }
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }
}

