/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class CelestialDawnToWhiteEffect
extends ContinuousEffectImpl {
    private static final FilterNonlandPermanent filter = new FilterNonlandPermanent();

    public CelestialDawnToWhiteEffect() {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Nonland permanents you control are white. The same is true for spells you control and nonland cards you own that aren't on the battlefield.";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                CelestialDawnToWhiteEffect.setColor(perm.getColor(game), game);
            }
            for (MageObject object : game.getStack()) {
                if (!(object instanceof Spell) || !((Spell)object).isControlledBy(controller.getId())) continue;
                CelestialDawnToWhiteEffect.setColor(object.getColor(game), game);
            }
            for (Card card : game.getExile().getCardsInRange(game, controller.getId())) {
                if (!card.isOwnedBy(controller.getId())) continue;
                CelestialDawnToWhiteEffect.setColor(card.getColor(game), game);
            }
            for (CommandObject commandObject : game.getState().getCommand()) {
                if (!(commandObject instanceof Commander) || !commandObject.isControlledBy(controller.getId())) continue;
                CelestialDawnToWhiteEffect.setColor(commandObject.getColor(game), game);
            }
            for (Card card : controller.getHand().getCards(game)) {
                CelestialDawnToWhiteEffect.setColor(card.getColor(game), game);
            }
            for (Card card : controller.getLibrary().getCards(game)) {
                CelestialDawnToWhiteEffect.setColor(card.getColor(game), game);
            }
            for (Card card : controller.getGraveyard().getCards(game)) {
                CelestialDawnToWhiteEffect.setColor(card.getColor(game), game);
            }
            return true;
        }
        return false;
    }

    protected static void setColor(ObjectColor color, Game game) {
        color.setWhite(true);
        color.setGreen(false);
        color.setBlue(false);
        color.setBlack(false);
        color.setRed(false);
    }

    public CelestialDawnToWhiteEffect copy() {
        return new CelestialDawnToWhiteEffect(this);
    }

    private CelestialDawnToWhiteEffect(CelestialDawnToWhiteEffect effect) {
        super((ContinuousEffectImpl)effect);
    }
}

