/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CelestialRegulatorEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public CelestialRegulatorEffect() {
        super(Outcome.Tap);
        this.staticText = "choose target creature you don't control and tap it. If you control a creature with a counter on it, the chosen creature doesn't untap during its controller's next untap step";
    }

    private CelestialRegulatorEffect(CelestialRegulatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public CelestialRegulatorEffect copy() {
        return new CelestialRegulatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature == null) {
            return false;
        }
        targetCreature.tap(source, game);
        if (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) > 0) {
            game.addEffect((ContinuousEffect)new DontUntapInControllersNextUntapStepTargetEffect(), source);
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

