/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class CemeteryProwlerCostReductionEffect
extends CostModificationEffectImpl {
    CemeteryProwlerCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Spells you cast cost {1} less to cast for each card type they share with cards exiled with {this}";
    }

    private CemeteryProwlerCostReductionEffect(CemeteryProwlerCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public CemeteryProwlerCostReductionEffect copy() {
        return new CemeteryProwlerCostReductionEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (abilityToModify instanceof SpellAbility) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId()));
            ExileZone exileZone = game.getExile().getExileZone(exileId);
            Card castCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
            if (exileZone != null && castCard != null) {
                HashSet cardTypes = new HashSet();
                for (UUID cardId : exileZone) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    cardTypes.addAll(card.getCardType(game));
                }
                int sharedTypes = 0;
                for (CardType type : castCard.getCardType(game)) {
                    if (!cardTypes.contains(type)) continue;
                    ++sharedTypes;
                }
                if (sharedTypes > 0) {
                    CardUtil.reduceCost((Ability)abilityToModify, (int)sharedTypes);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId());
    }
}

