/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.HideawayPlayEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CemeteryTamperingEffect
extends OneShotEffect {
    CemeteryTamperingEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may mill three cards. Then if there are twenty or more cards in your graveyard, you may play the exiled card without paying its mana cost";
    }

    private CemeteryTamperingEffect(CemeteryTamperingEffect effect) {
        super((OneShotEffect)effect);
    }

    public CemeteryTamperingEffect copy() {
        return new CemeteryTamperingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Mill three cards?", source, game)) {
            player.millCards(3, source, game);
        }
        if (player.getGraveyard().size() >= 20) {
            new HideawayPlayEffect().apply(game, source);
        }
        return true;
    }
}

