/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.LoseAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CephalidSnitchEffect
extends LoseAbilityTargetEffect {
    private static final ObjectColor NONBLACK = new ObjectColor("WURG");

    public CephalidSnitchEffect() {
        super((Ability)ProtectionAbility.from((ObjectColor)ObjectColor.BLACK), Duration.EndOfTurn);
        this.staticText = "Target creature loses protection from black until end of turn.";
    }

    private CephalidSnitchEffect(CephalidSnitchEffect effect) {
        super((LoseAbilityTargetEffect)effect);
    }

    public CephalidSnitchEffect copy() {
        return new CephalidSnitchEffect(this);
    }

    private static String filterNameAssembler(List<ObjectColor> colors) {
        if (colors.size() == 1) {
            return colors.get(0).getDescription();
        }
        if (colors.size() == 2) {
            return colors.get(0).getDescription() + " and from " + colors.get(1).getDescription();
        }
        if (colors.size() == 3) {
            return colors.get(0).getDescription() + ", from " + colors.get(1).getDescription() + " and from " + colors.get(2).getDescription();
        }
        if (colors.size() == 4) {
            return colors.get(0).getDescription() + ", from " + colors.get(1).getDescription() + ", from " + colors.get(2).getDescription() + " and from " + colors.get(3).getDescription();
        }
        return "";
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            ArrayList<ProtectionAbility> toRemove = new ArrayList<ProtectionAbility>();
            for (ProtectionAbility a : targetCreature.getAbilities().getProtectionAbilities()) {
                ObjectColor colors = a.getFromColor();
                if (!colors.isBlack()) continue;
                List nonBlackColors = colors.intersection(NONBLACK).getColors();
                if (!nonBlackColors.isEmpty()) {
                    FilterCard filter = new FilterCard(CephalidSnitchEffect.filterNameAssembler(nonBlackColors));
                    if (nonBlackColors.size() == 1) {
                        filter.add((Predicate)new ColorPredicate((ObjectColor)nonBlackColors.get(0)));
                    } else if (nonBlackColors.size() == 2) {
                        filter.add(Predicates.or((Predicate)new ColorPredicate((ObjectColor)nonBlackColors.get(0)), (Predicate)new ColorPredicate((ObjectColor)nonBlackColors.get(1))));
                    } else if (nonBlackColors.size() == 3) {
                        filter.add(Predicates.or((Predicate[])new Predicate[]{new ColorPredicate((ObjectColor)nonBlackColors.get(0)), new ColorPredicate((ObjectColor)nonBlackColors.get(1)), new ColorPredicate((ObjectColor)nonBlackColors.get(2))}));
                    } else if (nonBlackColors.size() == 4) {
                        filter.add(Predicates.or((Predicate[])new Predicate[]{new ColorPredicate((ObjectColor)nonBlackColors.get(0)), new ColorPredicate((ObjectColor)nonBlackColors.get(1)), new ColorPredicate((ObjectColor)nonBlackColors.get(2)), new ColorPredicate((ObjectColor)nonBlackColors.get(3))}));
                    }
                    a.setFilter(filter);
                    continue;
                }
                toRemove.add(a);
            }
            targetCreature.removeAbilities(toRemove, source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

