/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayTapOrUntapTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChainStasisEffect
extends OneShotEffect {
    ChainStasisEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may tap or untap target creature. Then that creature's controller may pay {2}{U}. If the player does, they may copy this spell and may choose a new target for that copy";
    }

    private ChainStasisEffect(ChainStasisEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainStasisEffect copy() {
        return new ChainStasisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            Spell spell;
            MayTapOrUntapTargetEffect effect = new MayTapOrUntapTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
            effect.apply(game, source);
            Player player = game.getPlayer(permanent.getControllerId());
            if (player == null) {
                return false;
            }
            ManaCostsImpl cost = new ManaCostsImpl("{2}{U}");
            if (cost.pay(source, game, source, controller.getId(), false) && player.chooseUse(this.outcome, "Copy the spell?", source, game) && (spell = game.getStack().getSpell(source.getSourceId())) != null) {
                spell.createCopyOnStack(game, source, player.getId(), true);
            }
            return true;
        }
        return false;
    }
}

